/******************************************************************************
 * (C) Copyright 2000 by Agilent Technologies GmbH. All rights reserved.      *
 ******************************************************************************/


/* ---------------------------------------------------------------
 * File: xberror.h
 *       error codes   
 * -----------------------------------------------------------------*/

#ifndef XBERROR_H_INCLUDED
#define XBERROR_H_INCLUDED

#ifndef CLI
#define CLI
#endif /* defined CLI */

typedef enum {
  BX_ERRPAR_1 = 0,
  BX_ERRPAR_2,
  BX_ERRPAR_3,
  BX_ERRPAR_4,
  BX_ERRPAR_5,
  BX_ERROR_NUMPARAMS    /* for internal use only */
} bx_errparamtype;


CLI typedef enum {
  BX_E_OK = 0,
  BX_EFW_OK = 0,

  /* generic error messages */
  BX_E_ERROR,
  BX_E_TRANSF_CMD,
  BX_E_INVALID_CASE_MSG,         
  BX_E_API_ERROR, 
  BX_E_FUNC,

  /* connecting to the card */
  BX_E_NO_HANDLE_LEFT,
  BX_E_BAD_HANDLE,
  BX_E_NOT_CONNECTED,
  BX_E_CANNOT_CONNECT,
  BX_E_CANNOT_CONNECT_EXCLUSIVE,    /* 10 */
  BX_E_CANNOT_CONNECT_CORE,
  BX_E_CONNECTION_LOST,
  BX_E_CONNECTION_LOST_CMD,                                  
  BX_E_UNKNOWN_HARDWARE,
  BX_E_VERSION_MISMATCH,

  /* mailbox */
  BX_E_MAILBOX_TIMEOUT,

  /* resource locking */
  BX_E_RESOURCE_LOCKED,

  /* command and data transfer */
  BX_E_ONLY_CORE,
  BX_E_CORE_VERSION_MISMATCH,
  BX_E_WRONG_PORT,                  /* 20 */
  BX_E_UNTRANSLATED_CMD,
  
  /* range checking and parameters */
  BX_E_NO_CAPABILITY, /* There is no hardware capability for this call at all */

  BX_E_PARAM,
  
  BX_E_VALUE,            /* the following 4 are overloaded by *//*20*/
  BX_E_RANGE,            /* dynamic capabilities */
  BX_E_ALIGN,
  BX_E_PARAM_NOT_EXIST,

  BX_E_SYNTAX,
  BX_E_FCT_PARAM,

  BX_E_UNDERFLOW,        /* these two errors appear whenever */ /* 30 */
  BX_E_OVERFLOW,         /* a return value is out of range   */

  /* master errors */
  BX_E_MASTER_ABORT,
  
  /* decoder errors */
  BX_E_DECODER,
   
  BX_E_CONFIG_VALUE_INVALID,
  BX_E_CONFIG_MASK_INVALID,
  
  /* host errors */
  BX_E_FILE_OPEN,
  BX_E_BAD_FILE_FORMAT,
  BX_E_HOST_MEM_FULL,
  
  /* miscellaneous errors */
  BX_E_UNKNOWN_ERR,
  BX_E_SELFTEST_FAILED,    /* 40 */
  
  /* developer's section */
  /* communication */
  BX_E_PARTIAL_XMIT,
  BX_E_PARTIAL_RCVE,

  BX_E_FILE_ITEM_NOT_FOUND,
  
  BX_E_TBD_MSG, /* ToBeDone, used also for DummyFunctions */
  BX_E_MAXERR,

  BX_E_INTERNAL_RETURN,

  
  /* *******************************************************************
   * Attention!!
   * Do not use any more error codes below this comment
   * *******************************************************************/
  
  /* serial port */
  BX_E_RS232_OPEN,
  BX_E_BAUDRATE,

  /* USB port */
  BX_E_USB_OPEN,

  /* PCI port */
  BX_E_PCI_OPEN,         /* 50 */
  BX_E_IO_OPEN,
  BX_E_NO_BEST_PCI_DEVICE_FOUND,
  BX_E_DRIVER_VERSION_DIFF,
  BX_E_PCI_NT_ONLY,              /* Attempt PCI open under non-WinNT */

  /* fast HIF port */
  BX_E_HIF_OPEN,
  BX_E_HIF_WIN32_ONLY,           /* Attempt HIF open under non-Win32 */

  /* simulation port */

  /* generic I/O ... any and all ports */

  BX_E_SETTING_TIMEOUTS,         /* Error setting timeouts */
  BX_E_BAD_DECODER_NUMBER,
  BX_E_PROG_DEC_ENABLE,
  BX_E_INVALID_OBS_RULE,  /* 60 */
  BX_E_NO_DWORD_BOUNDARY,
  BX_E_NO_WORD_BOUNDARY,
  BX_E_DEC_GRABBED,
  BX_E_WRONG_HW,                 /*"Operation not supported for that HW"*/

  /* (Returned from routines in xpci32rg.c): (no handle available) */
  BX_E_REG_VALUE_NOT_DWORD,      /* "The reg entry is not the correct type (Long Integer)" */
  BX_E_REG_VALUE_NOT_SZ,         /* "The registry entry is not the correct type (String)"*/
  BX_E_REG_VALUE_NOT_GET,        /* "Error retrieving the registry value" */
  BX_E_REG_VALUE_NOT_SET,        /* "Error setting the registry value" */
  BX_E_REG_KEY_NOT_OPEN,         /* "Unable to open the registry subkey (PCI driver loaded?)" */
  BX_E_REG_OWNER_NONE,           /*  " */ /* 70 */
  BX_E_REG_OWNER_IS_OTHER,       /*  " */
  BX_E_REG_NULL_PTR_PARAM,       /*  " */

  BX_E_DYNAMIC_CAPABILITY,     /* An Error concering the dynamic capabilities*/
  BX_E_PARAM_OUT_OF_RANGE,       /* A Parameter is out of range */
  BX_E_PARAM_NULL_POINTER,       /* NULL-pointer passed as argument */

  /* PPR error codes */
  BX_E_PPR_UNINITIALIZED,
  BX_E_PPR_LIST_TOO_LONG,
  BX_E_PPR_CMD_MIXED,        /* 80 */

  /* sequencer errors (common to all sequencer)                           */
  BX_E_SEQ_SYNTAX_ERR,        /* sequencer syntax error          */
  BX_E_SEQ_TOO_MANY_STATES,    /* too many states for this sequencer */
  BX_E_SEQ_TOO_MANY_INPUTS,    /* too many inputs for this sequencer */
  BX_E_SEQ_UNKNOWN_TOKEN,    /* don't know this token */
  BX_E_SEQ_TRAN_EXCLUSIVE,    /* transitions leaving a state not exclusive */

  /* pattern parser errors */
  BX_E_PATT_SYNTAX,
  BX_E_PATT_UNDEF_TOKEN,
  BX_E_PATT_MTO_LISTSIGNAL,
  BX_E_PATT_UNKNOWN_ERR,

  /* other errors */
  BX_E_ADBLIMITATION, /* used by PPR! */
  
  #ifdef CUSTOM_OEM1
  /* OEM Errors */  
  BX_E_OEM_OPEN,
  BX_E_OEM1,
  BX_E_OEM2,
  BX_E_OEM3,
  BX_E_OEM4,
  BX_E_OEM5,
  BX_E_OEM6,
  BX_E_OEM7,
  BX_E_OEM8,
  BX_E_OEM9,
  BX_E_OEM10,
#endif
  
  /* last error! */
  BX_E_COUNT,
  
  /* -------------------- FIRMWARE ERROR CODES -------------------- */
  BX_E_FIRMWARE = 10000,        /* internal delimiter */
  
  /* generic error messages */
  BX_EFW_ERROR,
  BX_EFW_FUNC,

  /* command and data transfer */
  BX_EFW_DATA_CHECKSUM,
  BX_EFW_CMDLOCKED,
  BX_EFW_NO_CAPABILITY,
  
  /* range checking and parameters */
  BX_EFW_PARAM,
  
  BX_EFW_VALUE,            /* the following 4 are overloaded by */
  BX_EFW_RANGE,            /* dynamic capabilities */
  BX_EFW_ALIGN,
  BX_EFW_PARAM_NOT_EXIST,
 
  /* decoder errors */
   BX_EFW_DECODER_GRABBED,

  /* Deep Trace Memory errors */
  BX_EFW_DEEPTRACE_FUNC,
  BX_EFW_PERF_DEEPTRACE_MISSING,
  
  /* environment related errors */

  BX_EFW_PCICLK_TOO_SLOW,    /* pciclk too slow or not running  */
  BX_EFW_PCICLK_TOO_FAST,    /* pciclk too fast                 */
  BX_EFW_PCI_NOPOWER,        /* power good not signaled */
  BX_EFW_EX_INIMODESET_FAILED,    /* programming failed, because ... */

  /* miscellaneous errors */
  BX_EFW_ICHIBANTEST_FAILED,
  BX_EFW_IMAGE_TOO_LARGE,
  BX_EFW_CARD_MEM_FULL,

  /* developers' errors */
  BX_EFW_TBD,                    /* to be done */
  BX_EFW_MAXERR,
  
  BX_EFW_UNKNOWNCMD,              /* cmd not leading to a valid entry (2) */
  
  /* *******************************************************************
   * Attention!!
   * Do not use any more error codes below this comment
   * *******************************************************************/
  

  BX_EFW_INVALID_KEY,        /* a key (e.g. license) was invalid (0) */

  /* register file */
  BX_EFW_WRONGPORT,        /* a request was issued from a wrong port */
                  
  /* UNIX debug session */
  BX_EFW_EOF,            /* unexpected end of file */
  BX_EFW_FWRITE,            /* error during file write operation */
  BX_EFW_FREAD,            /* error during file read operation */

  /* ------------------------------------------------------------------ */
  /* ------------------------------------------------------------------ */
  /* -------- BLOCK AND ATTRIBUTE MEMORY ------------------------------ */
  /* ------------------------------------------------------------------ */
  /* ------------------------------------------------------------------ */

  BX_EFW_COUNT,

  BX_EFW_CORE_UPDATED = 10254,
  BX_EFW_LONG_OPERATION = 10255,
  
  /* ------------------------------------------------------------------ */
  /* ------------------------------------------------------------------ */
  /* --------some internal error messages - always at the end---------- */
  /* ------------------------------------------------------------------ */
  /* ------------------------------------------------------------------ */
  BX_EFW_INTERNAL_RETURN,
  BX_EFW_CMDFOUND
  
  /* -------- do NOT put anything after this line !!!! ----------- */  
} bx_errtype;



/* range groups */

/* NOTE: keep entries aligned with pcst_list array in error.c !! */
typedef enum {
  BX_PCST_UNKNOWN,        /* has to be the first */

  /* TODO: throw out all the generic stuff, that's not the purpose of this */
  BX_PCST_MATTR_PAGE,
  BX_PCST_TATTR_PAGE,
  BX_PCST_TRIGGER_CTR,
  BX_PCST_MBLOCK_PAGE,
  BX_PCST_OFFSET,
  BX_PCST_VALUE,
  BX_PCST_GROUP,
  BX_PCST_CONFIG_REG,
  BX_PCST_NUMBEROFBYTES,
  BX_PCST_DMEM_ADDR,

  BX_PCST_TRCMEM_NOL,
  BX_PCST_TRCMEM_NOB,
  BX_PCST_TRCMEM_OFFSET,
  
  BX_PCST_ADDRESS,
  BX_PCST_SIZE,
  BX_PCST_DEVICE,

  BX_PCST_PPR_BPP,        /* ppr block permutation property */
  BX_PCST_PPR_APP,        /* ppr attr permutation property */
  BX_PCST_PPR_GEN,        /* ppr generic property */
  BX_PCST_PPR_REP,        /* ppr generic property */

  BX_PCST_LAST            /* has to be the last */
} bx_paramcustom;


typedef enum {
  BX_GENCMD_IO_READ,
  BX_GENCMD_IO_WRITE,
  BX_GENCMD_MEM_READ,
  BX_GENCMD_MEM_WRITE,
  BX_GENCMD_CONFIG_READ,
  BX_GENCMD_CONFIG_WRITE
} bx_gencommandtype;


typedef enum {
  BX_PGMEM_BLOCK,
  BX_PGMEM_MATTR,
  BX_PGMEM_TATTR
} bx_pagememtype;


typedef enum {
  BX_VERCHK_FIRMWARE
} bx_versioncheck;


typedef enum {
  BX_EERR_UNKNOWN,
  BX_EERR_READ_WRITE,    /* ReadFile/WriteFile returned with error */
  BX_EERR_GENERIC_READ,    /* generic on read error */
  BX_EERR_GENERIC_WRITE,    /* generic on write error */
  BX_EERR_DRV_FAILURE,    /* a driver returned no success */
  BX_EERR_DRV_TIMEOUT,    /* timeout detected by driver */
  BX_EERR_CAPI_TIMEOUT,    /* timeout detected by CAPI */
  BX_EERR_PARTIAL_RCVE,    /* partial receive error detected in io32.c */
  BX_EERR_UNKNOWN_REPLY    /* the E2925A returned an unknown reply byte */
} bx_e_error_type;


/* obsolete !! */
enum {
  BX_ERG_ANY,
  
  BX_ERG_EXERCISER,
  
  BX_ERG_MASTER,
  BX_ERG_TARGET,
  BX_ERG_TDEC,
  BX_ERG_TDECPROP,
  BX_ERG_CONFIG,
  
  BX_ERG_ANALYZER,

  BX_ERG_CPUPORT,
  BX_ERG_CPPROP
};


/* error group config members */

/* obsolete !! */
enum {
  BX_ERG_CONFIG_OFFSET,
  BX_ERG_CONFIG_VALUE,
  BX_ERG_CONFIG_MASK
};

#define BX_E_TBD (BestXLastErrorParamStringSet(handle, __FILE__), \
    BestXLastErrorParamSet(handle, BX_ERRPAR_1, __LINE__), BX_E_TBD_MSG)

#define BX_E_INVALID_CASE (BestXLastErrorParamStringSet(handle, __FILE__), \
    BestXLastErrorParamSet(handle, BX_ERRPAR_1, __LINE__), BX_E_INVALID_CASE_MSG)

/* error messages */

#define BX_E_ERROR_MSG_SET(x) \
  {BestXLastErrorParamSet(handle, BX_ERRPAR_1,__LINE__);\
   BestXLastErrorParamStringSet(handle,x " (file: " __FILE__ ", line: ");\
  }



/* do not add code below this point */
#endif /* defined xberror_h_included */
